#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/commit.h"
#include "maps/wikimap/mapspro/services/editor/src/observers/observer.h"
#include <yandex/maps/wiki/common/format_type.h>

namespace maps {
namespace wiki {

class ObjectsCache;
class ObjectsUpdateSnap;

template <>
struct controller::ResultType<ObjectsUpdateSnap>
{
    std::string taskName;
    Token token;
    std::optional<CommitModel> commit;
};

class ObjectsUpdateSnap: public controller::BaseController<ObjectsUpdateSnap>
{
public:
    struct Request
    {
        std::string dump() const;
        TUid userId() const { return userContext.uid(); }

        std::string body;
        UserContext userContext;
        TBranchId branchId;
        common::FormatType format;
    };

    ObjectsUpdateSnap(
        const ObserverCollection& observers,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();

    virtual std::string printRequest() const;

protected:
    virtual void control();

    void saveAndNotify(ObjectsCache&);

private:
    const ObserverCollection& observers_;

    Request request_;
};

} // namespace wiki
} // namespace maps
