#include "objects_update_snap_meta.h"

#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"

namespace maps::wiki {

namespace {
const std::string TASK_METHOD_NAME = "ObjectsUpdateSnapMeta";
const std::string ACTION_ID = "snap";
}

ObjectsUpdateSnapMeta::ObjectsUpdateSnapMeta(const Request& request)
    : controller::BaseController<ObjectsUpdateSnapMeta>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
}

const std::string&
ObjectsUpdateSnapMeta::taskName()
{
    return TASK_METHOD_NAME;
}

std::string
ObjectsUpdateSnapMeta::Request::dump() const
{
    std::stringstream ss;
    ss << " uid: " << uid;
    return ss.str();
}

std::string
ObjectsUpdateSnapMeta::printRequest() const
{
    return request_.dump();
}

void
ObjectsUpdateSnapMeta::control()
{
    const auto& updateRestrictions = cfg()->editor()->objectsUpdateRestrictions();
    result_->categoryIds = updateRestrictions.actionCategoryIds(ACTION_ID);
    if (result_->categoryIds.empty()) {
        result_->categoryIds = updateRestrictions.allowedCategoryIds(ACTION_ID);
    }
    result_->maxObjects = updateRestrictions.maxObjects(ACTION_ID);
}

} // namespace maps::wiki
