#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps::wiki {

class ObjectsUpdateSnapMeta;

template<>
struct controller::ResultType<ObjectsUpdateSnapMeta>
{
    StringSet categoryIds;
    size_t maxObjects;
};

class ObjectsUpdateSnapMeta
    : public controller::BaseController<ObjectsUpdateSnapMeta>
{
public:
    struct Request
    {
        std::string dump() const;

        TUid uid;
    };

    explicit ObjectsUpdateSnapMeta(const Request& request);

    virtual ~ObjectsUpdateSnapMeta() = default;

    static const std::string& taskName();

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace maps::wiki
