#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/commit.h"
#include "maps/wikimap/mapspro/services/editor/src/observers/observer.h"
#include <yandex/maps/wiki/common/format_type.h>

namespace maps {
namespace wiki {

class ObjectsCache;
class ObjectsUpdateState;
class ObserverCollection;

template<>
struct controller::ResultType<ObjectsUpdateState>
{
    std::string taskName;
    Token token;
    std::optional<CommitModel> commit;
};

class ObjectsUpdateState: public controller::BaseController<ObjectsUpdateState>
{
public:
    struct Request
    {
        Request(UserContext u, TOid oid, std::string s, TBranchId branchId,
                std::string body, common::FormatType format,
                boost::optional<TId> feedbackTaskId = boost::none)
            : userContext(std::move(u))
            , objectId(oid)
            , state(std::move(s))
            , branchId(branchId)
            , body(std::move(body))
            , format(format)
            , feedbackTaskId(std::move(feedbackTaskId))
        {}

        std::string dump() const;
        TUid userId() const { return userContext.uid(); }

        UserContext userContext;
        TOid objectId;
        std::string state;
        TBranchId branchId;
        std::string body;
        common::FormatType format;
        boost::optional<TId> feedbackTaskId;
    };

    ObjectsUpdateState(
        const ObserverCollection& observers,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

    void setObjectState();

    void saveAndNotify(ObjectsCache&);

private:
    const ObserverCollection& observers_;

    Request request_;
};

} // namespace wiki
} // namespace maps
