#include "objects_update_state_meta.h"

#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"

namespace maps::wiki {

namespace {
const std::string TASK_METHOD_NAME = "ObjectsUpdateStateMeta";
const std::string ACTION_ID_DELETE = "delete";
}

ObjectsUpdateStateMeta::ObjectsUpdateStateMeta(const Request& request)
    : controller::BaseController<ObjectsUpdateStateMeta>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
}

const std::string&
ObjectsUpdateStateMeta::taskName()
{
    return TASK_METHOD_NAME;
}

std::string
ObjectsUpdateStateMeta::Request::dump() const
{
    std::stringstream ss;
    ss << " uid: " << uid;
    return ss.str();
}

std::string
ObjectsUpdateStateMeta::printRequest() const
{
    return request_.dump();
}

void
ObjectsUpdateStateMeta::control()
{
    const auto& updateRestrictions = cfg()->editor()->objectsUpdateRestrictions();
    result_->categoryIds = updateRestrictions.actionCategoryIds(ACTION_ID_DELETE);
    if (result_->categoryIds.empty()) {
        result_->categoryIds = updateRestrictions.allowedCategoryIds(ACTION_ID_DELETE);
    }
    result_->maxObjects = updateRestrictions.maxObjects(ACTION_ID_DELETE);
}

} // namespace maps::wiki
