#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps::wiki {

class ObjectsUpdateStateMeta;

template<>
struct controller::ResultType<ObjectsUpdateStateMeta>
{
    StringSet categoryIds;
    size_t maxObjects;
};

class ObjectsUpdateStateMeta
    : public controller::BaseController<ObjectsUpdateStateMeta>
{
public:
    struct Request
    {
        std::string dump() const;

        TUid uid;
    };

    explicit ObjectsUpdateStateMeta(const Request& request);

    virtual ~ObjectsUpdateStateMeta() = default;

    static const std::string& taskName();

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace maps::wiki
