#include "objects_update_sync_geometry_meta.h"

#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"

namespace maps {
namespace wiki {

namespace {
const std::string TASK_METHOD_NAME = "ObjectsUpdateSyncGeometryMeta";
const std::string ACTION_ID_SYNC_GEOMETRY = "sync-geometry";
}

ObjectsUpdateSyncGeometryMeta::ObjectsUpdateSyncGeometryMeta(const Request& request)
    : controller::BaseController<ObjectsUpdateSyncGeometryMeta>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
}

const std::string&
ObjectsUpdateSyncGeometryMeta::taskName()
{
    return TASK_METHOD_NAME;
}

std::string
ObjectsUpdateSyncGeometryMeta::Request::dump() const
{
    std::stringstream ss;
    ss << " uid: " << uid;
    return ss.str();
}

std::string
ObjectsUpdateSyncGeometryMeta::printRequest() const
{
    return request_.dump();
}

void
ObjectsUpdateSyncGeometryMeta::control()
{
    const auto& updateRestrictions = cfg()->editor()->objectsUpdateRestrictions();
    result_->categoryIds = updateRestrictions.actionCategoryIds(ACTION_ID_SYNC_GEOMETRY);
    result_->maxObjects = updateRestrictions.maxObjects(ACTION_ID_SYNC_GEOMETRY);
}

} // namespace wiki
} // namespace maps
