#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps {
namespace wiki {

class ObjectsUpdateSyncGeometryMeta;

template<>
struct controller::ResultType<ObjectsUpdateSyncGeometryMeta>
{
    StringSet categoryIds;
    size_t maxObjects;
};

class ObjectsUpdateSyncGeometryMeta
    : public controller::BaseController<ObjectsUpdateSyncGeometryMeta>
{
public:
    struct Request
    {
        std::string dump() const;

        TUid uid;
    };

    explicit ObjectsUpdateSyncGeometryMeta(const Request& request);

    virtual ~ObjectsUpdateSyncGeometryMeta() = default;

    static const std::string& taskName();

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace wiki
} // namespace maps
