#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/commit.h"
#include "maps/wikimap/mapspro/services/editor/src/observers/observer.h"
#include <yandex/maps/wiki/common/format_type.h>

namespace maps {
namespace wiki {

class ObjectsCache;
class GeoObjectCollection;
class ObjectsUpdateUnion;

template<>
struct controller::ResultType<ObjectsUpdateUnion>
{
    std::string taskName;
    Token token;
    std::optional<CommitModel> commit;
};

class ObjectsUpdateUnion: public controller::BaseController<ObjectsUpdateUnion>
{
public:
    struct Request
    {
        std::string dump() const;
        TUid userId() const { return userContext.uid(); }

        std::string body;
        UserContext userContext;
        TBranchId branchId;
        common::FormatType format;
    };

    ObjectsUpdateUnion(const ObserverCollection& observers,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);
    virtual ~ObjectsUpdateUnion() {}

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();
    void saveAndNotify(GeoObjectCollection&, ObjectsCache&);

private:
    Request request_;
    const ObserverCollection& observers_;
};

} // namespace wiki
} // namespace maps
