#include "objects_update_union_meta.h"

#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"

namespace maps::wiki {

namespace {
const std::string TASK_METHOD_NAME = "ObjectsUpdateUnionMeta";
const std::string ACTION_ID = "union";
}

ObjectsUpdateUnionMeta::ObjectsUpdateUnionMeta(const Request& request)
    : controller::BaseController<ObjectsUpdateUnionMeta>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
}

const std::string&
ObjectsUpdateUnionMeta::taskName()
{
    return TASK_METHOD_NAME;
}

std::string
ObjectsUpdateUnionMeta::Request::dump() const
{
    std::stringstream ss;
    ss << " uid: " << uid;
    return ss.str();
}

std::string
ObjectsUpdateUnionMeta::printRequest() const
{
    return request_.dump();
}

void
ObjectsUpdateUnionMeta::control()
{
    const auto& updateRestrictions = cfg()->editor()->objectsUpdateRestrictions();
    result_->categoryIds = updateRestrictions.actionCategoryIds(ACTION_ID);
    if (result_->categoryIds.empty()) {
        result_->categoryIds = updateRestrictions.allowedCategoryIds(ACTION_ID);
    }
    result_->maxObjects = updateRestrictions.maxObjects(ACTION_ID);
}

} // namespace maps::wiki
