#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps::wiki {

class ObjectsUpdateUnionMeta;

template<>
struct controller::ResultType<ObjectsUpdateUnionMeta>
{
    StringSet categoryIds;
    size_t maxObjects;
};

class ObjectsUpdateUnionMeta
    : public controller::BaseController<ObjectsUpdateUnionMeta>
{
public:
    struct Request
    {
        std::string dump() const;

        TUid uid;
    };

    explicit ObjectsUpdateUnionMeta(const Request& request);

    virtual ~ObjectsUpdateUnionMeta() = default;

    static const std::string& taskName();

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace maps::wiki
