#pragma once

#include "maps/wikimap/mapspro/services/editor/src/common.h"
#include "maps/wikimap/mapspro/services/editor/src/views/view_object.h"
#include <maps/wikimap/mapspro/libs/poi_conflicts/include/poi_conflicts.h>

namespace maps::wiki {

const TZoom COMMON_MIN_CRITICAL_CONFLICT_ZOOM = 20;
const TZoom GEOPRODUCT_MIN_CRITICAL_CONFLICT_ZOOM = 18;

using PoiConflictsData = std::map<TZoom, std::map<poi_conflicts::ConflictSeverity, views::ViewObjects>, std::greater<TZoom>>;

class PoiConflictingCategories
{
public:
    PoiConflictingCategories();
    const StringSet& operator()() const { return data_; }

private:
    StringSet data_;
};

enum class IndoorPoiPolicy
{
    Exclude,
    Include
};

StringSet poiCategoryIds(IndoorPoiPolicy indoorPoiPolicy = IndoorPoiPolicy::Include);
bool isGeoproduct(const views::ViewObject& object);
bool userHasAccessToGeoproducts(
    TUid uid, const
    PoiConflictingCategories& categoriesHolder,
    Transaction& workCore);
poi_conflicts::Kind conflictKind(
    bool firstIsGeoproduct,
    bool secondIsGeoproduct);
poi_conflicts::ConflictSeverity conflictSeverity(
    TZoom zoom,
    bool escalateGeoproduct,
    poi_conflicts::Kind kind);

} // namespace maps::wiki
