#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps {
namespace wiki {

class PointToBld;
template<> struct controller::ResultType<PointToBld>
{
    Geom point;
    double distance;
    double azimuth;
    bool isInsideBld;
    TOid bldId;
};

class PointToBld: public controller::BaseController<PointToBld>
{
public:
    struct Request
    {
        std::string dump() const;

        std::string pointGeoJson;
        std::string bldNumber;
        TBranchId branchId;
        Token token;
    };

    explicit PointToBld(const Request& request);

    virtual ~PointToBld() {}

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace wiki
} // namespace maps
