#include "common.h"

namespace maps {
namespace wiki {

bool operator<(const LevelJunctionID& lhs, const LevelJunctionID& rhs)
{
    return (lhs.id < rhs.id) || (lhs.id == rhs.id && lhs.zlev < rhs.zlev);
}

CompoundNodeID::CompoundNodeID(const DirectedElementID& directedElementId)
    : directedElementId(directedElementId)
    , conditionPath()
{}

CompoundNodeID::CompoundNodeID(
        const DirectedElementID& directedElementId,
        ConditionPath conditionPath)
    : directedElementId(directedElementId)
    , conditionPath(std::move(conditionPath))
{}

bool operator<(const CompoundNodeID& lhs, const CompoundNodeID& rhs)
{
    return (lhs.directedElementId < rhs.directedElementId) ||
        (lhs.directedElementId == rhs.directedElementId && lhs.conditionPath < rhs.conditionPath);
}

ConditionPosition::ConditionPosition(TOid conditionId, int seqNum)
    : conditionId(conditionId)
    , seqNum(seqNum)
{}

} // namespace wiki
} // namepspace maps

