#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>

#include <yandex/maps/wiki/routing/common.h>

#include <vector>

namespace maps {
namespace wiki {

typedef routing::Direction Direction;
typedef routing::DirectedElementID DirectedElementID;

struct LevelJunctionID {
    TOid id;
    int zlev;
};

bool operator<(const LevelJunctionID& lhs, const LevelJunctionID& rhs);

typedef std::vector<TOid> ConditionPath;

struct CompoundNodeID {
    DirectedElementID directedElementId;
    ConditionPath conditionPath;

    explicit CompoundNodeID(const DirectedElementID& elementId);
    CompoundNodeID(const DirectedElementID& directedElementId, ConditionPath conditionPath);
};

bool operator<(const CompoundNodeID& lhs, const CompoundNodeID& rhs);

struct ConditionPosition {
    TOid conditionId;
    int seqNum;

    ConditionPosition(TOid conditionId, int seqNum);
};

typedef std::vector<ConditionPosition> ConditionPositions;

} // namespace wiki
} // namespace maps
