#pragma once

#include "common.h"
#include "route_condition.h"
#include "route_element.h"

#include <maps/libs/geolib/include/bounding_box.h>
#include <yandex/maps/wiki/routing/stop.h>

#include <boost/optional.hpp>

#include <functional>
#include <string>

namespace maps {
namespace wiki {

// Return true, if route element should be considered by graph.
typedef std::function<bool(const RouteElement&)> RouteElementFilter;

// Return direction of route element. You may return actual attribute value or
// some default value if there is no one. Also it may be useful for one-way roads
// with reverse lane for public transport
typedef std::function<Direction(const RouteElement&)> DirectionExtractor;

// Return cost of transition between adjacent elements, value >= 0.
// You may use distance, travel time and etc.
typedef std::function<double(const RouteElement&, const RouteElement&)> TransitionWeightFunction;

// Return true, if route condition should be considered by graph.
// Re: Condition is any master object that has 'from' or 'to' realtion with route element.
typedef std::function<bool(const RouteCondition&)> RouteConditionFilter;

// Graph is able to consider only two types of maneuver:
// * Forbidden maneuver (continuous sequence of elements with no repetitions)
// * Turnaround (consist only of two elements)
// If condition has another type, you must filter it with RouteConditionFilter!
//
enum class RouteConditionType { Forbidden, Turnabout };

typedef std::function<RouteConditionType(const RouteCondition&)> RouteConditionTypeExtrator;


struct RoutingConditionConfig {
    RouteConditionFilter filter;
    RouteConditionTypeExtrator type;
};


struct RoutingConfig {
    std::string elementCategoryId;
    geolib3::BoundingBox aoi;
    DirectionExtractor direction;
    RouteElementFilter filter;
    TransitionWeightFunction weight;
    boost::optional<RoutingConditionConfig> condition;
    double cacheRadiusMeters;
    size_t loadElementsLimit;
};

constexpr double DEFAULT_STOP_SEARCH_RADIUS_METERS = 30;

RoutingConfig defaultTransportRoutingConfig(
        const std::string& threadCategoryId,
        const routing::Stops& stops);

} // namespace wiki
} // namespace maps
