#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include "thread_stop.h"


#include <string>
#include <vector>


namespace maps {
namespace wiki {

class GetRouteTime;
class ObserverCollection;

template<>
struct controller::ResultType<GetRouteTime> {
    std::vector<size_t> time;
};

class GetRouteTime : public controller::BaseController<GetRouteTime> {

public:

    struct Request {
        TUid user;
        Token token;
        TBranchId branchId;

        TRevisionId revisionId;
        std::string categoryId;

        TOIds addElementIds;
        TOIds removeElementIds;

        ThreadStopSequence threadStopSequence;

        std::string dump() const;
        TUid userId() const { return user; }
    };

    GetRouteTime(
            const ObserverCollection&,
            const Request& request,
            taskutils::TaskID asyncTaskID = 0);

    virtual ~GetRouteTime() {}

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

    Request request_;
};

} // namespace wiki
} // namespace maps
