#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/services/editor/src/views/view_object.h>

#include <maps/libs/geolib/include/bounding_box.h>

#include <boost/optional.hpp>

#include <string>
#include <vector>


namespace maps {
namespace wiki {

class ObjectsQueryPath;
class ObserverCollection;

template<>
struct controller::ResultType<ObjectsQueryPath> {
    views::ViewObjects elements;
    geolib3::BoundingBox elementBBox;
};

class ObjectsQueryPath : public controller::BaseController<ObjectsQueryPath> {

public:

    struct Request {
        TUid user;
        Token token;
        TBranchId branchId;

        std::vector<TOid> elementIds;
        size_t elementLimit;

        std::string dump() const;
        TUid userId() const { return user; }
    };

    ObjectsQueryPath(
            const ObserverCollection&,
            const Request& request,
            taskutils::TaskID asyncTaskID = 0);

    virtual ~ObjectsQueryPath() {}

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

    Request request_;
};

} // namespace wiki
} // namespace maps
