#include "result_helper.h"
#include <maps/wikimap/mapspro/services/editor/src/views/objects_query.h>

#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {

views::ViewObjects loadViewObjects(Transaction& workView, TBranchId branchId, const TOIds& objectIds)
{
    if (objectIds.empty()) {
        return {};
    }

    views::ObjectsQuery objectsQuery;
    objectsQuery.addCondition(views::OidsCondition(objectIds));
    return objectsQuery.exec(workView, branchId);
}

geolib3::BoundingBox findBoundingBox(const views::ViewObjects& viewObjects)
{
    REQUIRE(
        !viewObjects.empty(),
        "View object list is empty"
    );

    auto it = viewObjects.begin();

    geos::geom::Envelope envelope = *(it->geom()->getEnvelopeInternal());
    for (++it; it != viewObjects.end(); ++it) {
        envelope.expandToInclude(it->geom()->getEnvelopeInternal());
    }

    return geolib3::BoundingBox{
        {envelope.getMinX(), envelope.getMinY()},
        {envelope.getMaxX(), envelope.getMaxY()}
    };
}

} // namespace wiki
} // namespace maps
