#pragma once

#include "route_object.h"

#include "common.h"

#include <yandex/maps/wiki/revision/objectrevision.h>
#include <yandex/maps/wiki/revision/snapshot.h>

#include <vector>


namespace maps {
namespace wiki {

class RouteCondition: public RouteObject {

public:
    static const int FROM_SEQ_NUM;

    RouteCondition(
        const revision::ObjectRevision& revision,
        TOid fromElementId,
        TOid viaJunctionId,
        std::vector<TOid> toElementIds
    );

    TOid fromElementId() const;

    TOid viaJunctionId() const;

    const std::vector<TOid>& toElementIds() const;

    int lastSeqNum() const;

    bool isLastSeqNum(int seqNum) const;

    bool isFromSeqNum(int seqNum) const;

    TOid at(int seqNum) const;

    ConditionPath pathTo(int toSeqNum) const;

    static std::vector<RouteCondition> load(revision::Snapshot& snapshot, const TOIds& ids);

private:
    void checkSeqNum(int seqNum) const;

    TOid fromElementId_;
    TOid viaJunctionId_;
    std::vector<TOid> toElementIds_;
};

} // namespace wiki
} // namespace maps
