#pragma once

#include "route_object.h"

#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/polyline.h>

#include <yandex/maps/wiki/common/rd/access_id.h>
#include <yandex/maps/wiki/common/rd/fow.h>
#include <yandex/maps/wiki/revision/objectrevision.h>


namespace maps {
namespace wiki {


typedef common::FOW FOW;
typedef common::AccessId AccessId;

struct SpeedInterval {
	double min;
	double max;
};

constexpr double KMH_TO_MS_RATIO = 10.0 / 36.0;

class RouteElement: public RouteObject {

public:
    RouteElement(const revision::ObjectRevision& revision);

    double lengthMeters() const;

    int speedCat() const;
    SpeedInterval speedIntervalMetersPerSecond() const;

    const geolib3::Polyline2& geom() const;

private:
    geolib3::Polyline2 geom_;
};

typedef std::vector<RouteElement> RouteElements;

} // namespace wiki
} // namespace maps
