#include "route_object.h"

#include "util.h"

#include <maps/libs/common/include/exception.h>

#include <boost/algorithm/string/predicate.hpp>


namespace maps {
namespace wiki {

namespace {

constexpr char ATTRIBUTE_PREFIX_SEPARATOR = ':';

} // namespace


RouteObject::RouteObject(const revision::ObjectRevision& revision)
    : id_(revision.id().objectId())
    , categoryId_(extractCategoryId(revision))
    , attributes_(extractAttributes(revision))
{}

TOid RouteObject::id() const { return id_; }

const std::string& RouteObject::categoryId() const { return categoryId_; }

std::string RouteObject::attributeId(const std::string& attr) const
{
    const auto it = std::find(attr.begin(), attr.end(), ATTRIBUTE_PREFIX_SEPARATOR);

    return it == attr.end()
        ? categoryId() + ATTRIBUTE_PREFIX_SEPARATOR + attr
        : attr;
}

common::AttrValue RouteObject::operator[](const std::string& attr) const
{
    return attributes_[attributeId(attr)];
}

common::AttrValues RouteObject::range(const std::string& attr) const
{
    return attributes_.range(attributeId(attr));
}

} // namespace wiki
} // namespace maps
