#pragma once

#include "common.h"

#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/attr_value.h>

#include <yandex/maps/wiki/revision/objectrevision.h>

#include <string>
#include <vector>

namespace maps {
namespace wiki {

class RouteObject {

public:
    RouteObject(const revision::ObjectRevision& revision);

    TOid id() const;

    const std::string& categoryId() const;

    common::AttrValue operator[](const std::string& attr) const;

    common::AttrValues range(const std::string& attr) const;

private:
    std::string attributeId(const std::string& attr) const;

    TOid id_;
    std::string categoryId_;
    common::AttrsWrap attributes_;
};

} // namespace wiki
} // namespace maps
