#pragma once

#include "common.h"

#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/attr_value.h>

#include <yandex/maps/wiki/common/string_utils.h>

#include <map>
#include <vector>


namespace maps {
namespace wiki {

struct ThreadStop {
    TOid id;
    TOid stopId;
    common::AttrsWrap attrs;

    ThreadStop(TOid id, TOid stopId, const StringMap& attrs);
    ThreadStop(TOid id, TOid stopId, const StringMultiMap& attrs);
};

typedef std::vector<ThreadStop> ThreadStopVector;

class ThreadStopSequence {

public:
    ThreadStopSequence();

    ThreadStopSequence(ThreadStopVector&& threadStops);

    size_t size() const;

    ThreadStop& at(TOid id);
    const ThreadStop& at(TOid id) const;

    ThreadStop& byId(TOid id);
    const ThreadStop& byId(TOid id) const;

    std::vector<TOid> stopIds() const;

    TOIds threadStopsWithoutStopId() const;
    TOIds threadStopsWithoutAttrs() const;

    std::string toString() const;

private:
    ThreadStopVector threadStops_;
    std::map<TOid, size_t> threadStopIdToIdx_;
};

} // namespace wiki
} // namespace maps
