#include "util.h"

#include <maps/wikimap/mapspro/services/editor/src/attributes.h>

#include <maps/libs/geolib/include/distance.h>

#include <geos/geom/Envelope.h>

namespace maps {
namespace wiki {

const StringMap& extractAttributes(const revision::ObjectRevision& revision)
{
    REQUIRE(
        revision.data().attributes,
        "Object " << revision.id() << " has no attributes"
    );

    return *revision.data().attributes;
}

std::string extractCategoryId(const revision::ObjectRevision& revision)
{
    std::string categoryId = categoryFromAttributes(extractAttributes(revision));
    REQUIRE(!categoryId.empty(), "Object " << revision.id() << " has no category attribute");
    return categoryId;
}

const revision::RelationData& extractRelation(const revision::ObjectRevision& revision)
{
    REQUIRE(
        revision.data().relationData,
        "Object " << revision.id() << " is not relation"
    );

    return *revision.data().relationData;
}

double mercatorRealLength(const geolib3::Point2& start, const geolib3::Point2& end)
{
    return geolib3::geoDistance(
        geolib3::mercator2GeoPoint(start),
        geolib3::mercator2GeoPoint(end)
    );
}

double mercatorRealLength(const geolib3::Polyline2& polyline)
{
    double length = 0.0;

    if (polyline.pointsNumber() >= 2) {
        geolib3::Point2 start = geolib3::mercator2GeoPoint(polyline.points().front());
        for (size_t i = 1; i < polyline.pointsNumber(); ++i) {
            geolib3::Point2 end = geolib3::mercator2GeoPoint(polyline.pointAt(i));
            length += geolib3::geoDistance(start, end);
            start = end;
        }
    }

    return length;
}

} // namespace wiki
} // namespace maps
