#pragma once

#include <yandex/maps/wiki/common/attr_value.h>

#include "common.h"
#include <maps/wikimap/mapspro/services/editor/src/utils.h>

#include <maps/libs/common/include/exception.h>

#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/polygon.h>
#include <maps/libs/geolib/include/serialization.h>

#include <yandex/maps/wiki/revision/objectrevision.h>
#include <yandex/maps/wiki/revision/snapshot.h>
#include <yandex/maps/wiki/routing/stop.h>

#include <initializer_list>
#include <sstream>
#include <string>
#include <vector>


namespace maps {
namespace wiki {

std::string extractCategoryId(const revision::ObjectRevision& revision);

const StringMap& extractAttributes(const revision::ObjectRevision& revision);

const revision::RelationData& extractRelation(const revision::ObjectRevision& revision);

template<typename T>
T extractGeom(const revision::ObjectRevision& revision)
{
    REQUIRE(
        revision.data().geometry,
        "Object " << revision.id() << " has no geometry"
    );

    return geolib3::WKB::read<T>(*revision.data().geometry);
}

double mercatorRealLength(const geolib3::Point2& start, const geolib3::Point2& end);

double mercatorRealLength(const geolib3::Polyline2& polyline);

} // namespace wiki
} // namespace maps
