#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/services/editor/src/user_context.h>
#include <yandex/maps/wiki/social/comment.h>
#include <yandex/maps/wiki/social/comments_feed.h>

#include <optional>

namespace maps {
namespace wiki {

class ObserverCollection;
class ClearUserComments;
template<>
struct controller::ResultType<ClearUserComments>
{
    size_t count;
    Token token;
};

class ClearUserComments : public controller::BaseController<ClearUserComments>
{
public:
    struct Request
    {
        Request(UserContext userContext, TUid createdBy);

        std::string dump() const;
        TUid userId() const { return userContext.uid(); }

        UserContext userContext;
        const TUid createdBy;
    };

    ClearUserComments(
        const ObserverCollection&,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace wiki
} // namespace maps
