#include "counters.h"
#include "feed_params.h"

#include <yandex/maps/wiki/social/gateway.h>

namespace maps {
namespace wiki {

CommentsCounters
loadCommentsCounters(
    const social::Gateway& gateway,
    const social::CommentsFeedParams& socialParams)
{
    CommentsCounters counters;
    counters.notRead = 0;
    counters.all = gateway.commentsFeed(socialParams).count();
    counters.totalCount = counters.all;

    return counters;
}

} // namespace wiki
} // namespace maps
