#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/services/editor/src/user_context.h>
#include <yandex/maps/wiki/social/comment.h>

#include <optional>

namespace maps::wiki {

class GeoObject;
class ObserverCollection;
class CommentsCreate;
class BranchContext;

template<>
struct controller::ResultType<CommentsCreate>
{
    std::optional<social::Comment> comment;
    Token token;
};

class CommentsCreate : public controller::BaseController<CommentsCreate>
{
public:
    struct Request
    {
        Request(
            UserContext userContext,
            social::CommentType type,
            const std::string& data,
            TCommitId commitId,
            TOid objectId,
            std::optional<TId> feedbackTaskId);

        static Request parseJson(UserContext userContext, const std::string& json);

        std::string dump() const;
        TUid userId() const { return userContext.uid(); }

        UserContext userContext;
        const social::CommentType type;
        const std::string data;
        const TCommitId commitId;
        const TOid objectId;
        const std::optional<TId> feedbackTaskId;
    };

    CommentsCreate(
        const ObserverCollection&,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    void createComment(
        BranchContext& branchCtx,
        const std::string& moderationStatus,
        TCommitId commitId,
        const TOIds& aoiIds);

    void finalizeComment(BranchContext& branchCtx);

    Request request_;
};

} // namespace maps::wiki
