#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/services/editor/src/user_context.h>
#include <yandex/maps/wiki/social/comment.h>

namespace maps {
namespace wiki {

class ObserverCollection;
class CommentsDelete;
template<>
struct controller::ResultType<CommentsDelete>
{
    boost::optional<social::Comment> comment;
    Token token;
};

class CommentsDelete : public controller::BaseController<CommentsDelete>
{
public:
    struct Request
    {
        Request(UserContext userContext, TId commentId);

        std::string dump() const;
        TUid userId() const { return userContext.uid(); }

        UserContext userContext;
        const TId commentId;
    };

    CommentsDelete(
        const ObserverCollection&,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace wiki
} // namespace maps
