#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "feed_params.h"
#include <yandex/maps/wiki/social/comments_feed.h>

namespace maps {
namespace wiki {

class GetCommentsFeed;
template<>
struct controller::ResultType<GetCommentsFeed>
{
    size_t totalCount;
    social::Comments comments;
    social::HasMore hasMore;
};

class GetCommentsFeed : public controller::BaseController<GetCommentsFeed>
{
public:
    struct Request
    {
        const FeedParams params;

        const size_t perPage;
        const social::TId olderThanCommentId;
        const social::TId newerThanCommentId;
        const Token token;
    };

    explicit GetCommentsFeed(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;
};

} // namespace wiki
} // namespace maps
