#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <yandex/maps/wiki/social/comments_feed.h>

#include <optional>

namespace maps {
namespace wiki {

class FeedParams
{
public:
    static FeedParams create(
        TUid uid,
        TOid objectId,
        TCommitId commitId,
        std::optional<TId> feedbackTaskId,
        TOid aoiId,
        TUid createdBy,
        social::CommentTypes commentTypes,
        social::comments::DeletedPolicy deletedPolicy,
        const Token& token);

    std::string dump() const;

    const social::CommentsFeedParams& commentsFeedParams() const
    {
        return params_;
    }

    TUid uid() const
    {
        return uid_;
    }

private:
    FeedParams(TUid uid, social::CommentsFeedParams params);

    const TUid uid_;
    social::CommentsFeedParams params_;
};

} // namespace wiki
} // namespace maps
