#include "logging.h"
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>

#include <yandex/maps/wiki/common/tskv_logger.h>

#include <maps/libs/chrono/include/time_point.h>

namespace maps {
namespace wiki {
namespace {
const std::string TSKV_LOG_FORMAT_NAME = "nmaps-comments-log";

enum class Action
{
    Create,
    Delete
};

std::string
toLogName(Action action)
{
    switch (action) {
        case Action::Create :
            return "sent";
        case Action::Delete :
            return "deleted";
    };
    ASSERT(false);
}

class CommentLogMessageData
{
public:
    common::TskvMessage
    tskvMessage() const
    {
        common::TskvMessage message(TSKV_LOG_FORMAT_NAME);
        message.setParam("id", id_);
        message.setParam("puid", actionBy_);
        message.setParam("timestamp", actionTime_);
        message.setParam("object_id", objectId_ ? std::to_string(objectId_) : s_emptyString);
        message.setParam("commit_id", commitId_ ? std::to_string(commitId_) : s_emptyString);
        message.setParam("action", toLogName(action_));
        return message;
    }

    TId id_;
    TUid actionBy_;
    time_t actionTime_;
    Action action_;
    TOid objectId_;
    TCommitId commitId_;
};
}//namespace

void
logCreateComment(const social::Comment& comment)
{
    if (!cfg()->commentsLogger()) {
        return;
    }
    CommentLogMessageData message {
        comment.id(),
        comment.createdBy(),
        chrono::convertToUnixTime(
            chrono::parseSqlDateTime(comment.createdAt())
        ),
        Action::Create,
        comment.objectId(),
        comment.commitId()
    };
    cfg()->commentsLogger()->log(message.tskvMessage());
}

void
logDeleteComment(const social::Comment& comment)
{
    if (!cfg()->commentsLogger()) {
        return;
    }
    CommentLogMessageData message {
        comment.id(),
        comment.deletedBy(),
        chrono::convertToUnixTime(
            chrono::parseSqlDateTime(comment.deletedAt())
        ),
        Action::Delete,
        comment.objectId(),
        comment.commitId()
    };
    cfg()->commentsLogger()->log(message.tskvMessage());
}

} // namespace wiki
} // namespace maps
