#include "stat.h"
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include <maps/wikimap/mapspro/services/editor/src/branch_helpers.h>

#include <yandex/maps/wiki/social/gateway.h>

namespace maps {
namespace wiki {

GetCommentsStat::GetCommentsStat(const Request& request)
    : controller::BaseController<GetCommentsStat>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{}

std::string
GetCommentsStat::printRequest() const
{
    std::stringstream ss;
    ss << request_.params.dump()
       << " token: " << request_.token;
    return ss.str();
}

void
GetCommentsStat::control()
{
    auto tokenSocial = getSocialToken(request_.token);
    auto workSocial = cfg()->poolSocial().slaveTransaction(tokenSocial);

    social::Gateway gateway(*workSocial);
    result_->counters = loadCommentsCounters(
        gateway,
        request_.params.commentsFeedParams()
    );
}

} // namespace wiki
} // namespace maps
