#include "get_feed_helper.h"

#include <maps/wikimap/mapspro/services/editor/src/branch_helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/serialize/common.h>
#include <maps/wikimap/mapspro/services/editor/src/social_utils.h>
#include <maps/wikimap/mapspro/services/editor/src/approve_status.h>
#include <maps/wikimap/mapspro/services/editor/src/commit.h>

#include <yandex/maps/wiki/common/paged_result.h>
#include <yandex/maps/wiki/social/gateway.h>
#include <yandex/maps/wiki/revision/revisionsgateway.h>
#include <yandex/maps/wiki/revision/branch_manager.h>
#include <yandex/maps/wiki/revision/filters.h>

#include <boost/optional.hpp>

#include <map>
#include <vector>
#include <unordered_map>

namespace maps {
namespace wiki {

void fillWithEvents(
    const BranchContext& branchCtx,
    controller::ResultType<GetSocialFeed>& result,
    social::Events events)
{
    if (events.empty()) {
        return;
    }

    std::vector<TCommitId> commitIds;
    std::unordered_map<TCommitId, social::TId> commitIdToEventId;
    for (const auto& event: events) {
        if (!event.commitData()) {
            continue;
        }
        auto commitId = event.commitData()->commitId();
        commitIds.push_back(commitId);
        commitIdToEventId.emplace(commitId, event.id());
    }

    auto commits = revision::Commit::load(
        branchCtx.txnCore(),
        revision::filters::CommitAttr::id().in(commitIds));
    REQUIRE(commits.size() == events.size(),
        " All events should refer to unique commits.");

    auto eventIdToApproveStatus = approve_status::evalEventsApproveStatuses(branchCtx, events, commits);

    BatchCommitPreparedFields batchPreparedFields;
    batchPreparedFields.prepareStates(branchCtx, commits);
    batchPreparedFields.prepareLastFlags(branchCtx, commits, result.branchId);

    // collect result
    std::unordered_map<TId, revision::Commit> eventIdToCommit;
    for (auto& commit : commits) {
        eventIdToCommit.emplace(commitIdToEventId.at(commit.id()), std::move(commit));
    }

    for (auto& event: events) {
        auto commitIt = eventIdToCommit.find(event.id());
        if (commitIt == eventIdToCommit.end()) {
            continue;
        }

        CommitModel commitModel(commitIt->second);
        batchPreparedFields.fillCommitModel(commitModel);
        commitModel.setApproveStatus(eventIdToApproveStatus.at(event.id()));

        result.eventModels.emplace_back(
            controller::ResultType<GetSocialFeed>::EventModel{std::move(event), std::move(commitModel)}
        );
    }
}


} // namespace wiki
} // namespace maps
