#include "get_feedback_task_stat.h"
#include <maps/wikimap/mapspro/services/editor/src/branch_helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>

#include <yandex/maps/wiki/social/feedback/commits.h>
#include <yandex/maps/wiki/social/feedback/task.h>
#include <yandex/maps/wiki/social/gateway.h>

namespace maps {
namespace wiki {

namespace {

const std::string TASK_METHOD_NAME = "GetFeedbackTaskStat";

} // namespace

GetSocialFeedbackTaskStat::GetSocialFeedbackTaskStat(const Request& request)
    : controller::BaseController<GetSocialFeedbackTaskStat>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{}

std::string
GetSocialFeedbackTaskStat::printRequest() const
{
    std::stringstream ss;
    ss << " uid: " << request_.uid;
    ss << " feedback-task-id: " << request_.feedbackTaskId;
    ss << " token: " << request_.token;
    return ss.str();
}

void
GetSocialFeedbackTaskStat::control()
{
    auto tokenSocial = getSocialToken(request_.token);
    auto workSocial = cfg()->poolSocial().slaveTransaction(tokenSocial);
    social::Gateway sgw(*workSocial);

    auto allCommitIds = social::feedback::commitIdsByTaskId(
        *workSocial, request_.feedbackTaskId);
    auto allEvents = sgw.loadEditEventsByCommitIds(allCommitIds);
    result_->commitsCount = allEvents.size();
}

const std::string&
GetSocialFeedbackTaskStat::taskName()
{
    return TASK_METHOD_NAME;
}

} // namespace wiki
} // namespace maps
