#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps {
namespace wiki {

class GetSocialFeedbackTaskStat;
template<>
struct controller::ResultType<GetSocialFeedbackTaskStat>
{
    size_t commitsCount;
};

class GetSocialFeedbackTaskStat: public controller::BaseController<GetSocialFeedbackTaskStat>
{
public:
    struct Request
    {
        const TUid uid;
        const TId feedbackTaskId;
        const Token token;
    };

    explicit GetSocialFeedbackTaskStat(const Request& request);
    ~GetSocialFeedbackTaskStat() override = default;

    static const std::string& taskName();
    std::string printRequest() const override;

protected:
    void control() override;

private:
    const Request request_;

};


} // namespace wiki
} // namespace maps
