#include "get_social_event.h"

#include <maps/wikimap/mapspro/services/editor/src/branch_helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>

#include <yandex/maps/wiki/social/gateway.h>

namespace maps::wiki {

GetSocialEvent::GetSocialEvent(const Request& request)
    : controller::BaseController<GetSocialEvent>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{}

std::string GetSocialEvent::printRequest() const
{
    std::stringstream ss;
    ss << " uid: " << request_.uid;
    ss << " event-id: " << request_.eventId;
    ss << " token: " << request_.token;
    return ss.str();
}

void GetSocialEvent::control()
{
    auto tokenSocial = getSocialToken(request_.token);
    auto workSocial = cfg()->poolSocial().slaveTransaction(tokenSocial);
    social::Gateway sgw(*workSocial);

    auto events = sgw.loadEventsByIds({request_.eventId});
    if (!events.empty()) {
        result_->event = std::move(events.front());
    }
}

} // namespace maps::wiki
