#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <yandex/maps/wiki/social/event.h>

#include <optional>

namespace maps::wiki {

class GetSocialEvent;
template<>
struct controller::ResultType<GetSocialEvent> {
    std::optional<social::Event> event;
};

class GetSocialEvent : public controller::BaseController<GetSocialEvent> {
public:
    struct Request {
        const TUid uid;
        const TId eventId;
        const Token token;
    };

    explicit GetSocialEvent(const Request& request);
    ~GetSocialEvent() override = default;

    std::string printRequest() const override;

private:
    void control() override;

    const Request request_;
};

} // namespace maps::wiki
