#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/services/editor/src/collection.h>
#include <yandex/maps/wiki/social/common.h>

namespace maps {
namespace wiki {

class GetSocialSubscriptions;
template<>
struct controller::ResultType<GetSocialSubscriptions>
{
    std::map<TOid, std::string, std::greater<TOid>> regionIdToTitle;
};

class GetSocialSubscriptions : public controller::BaseController<GetSocialSubscriptions>
{
public:
    struct Request
    {
        const TUid user;
        const Token token;
    };

    explicit GetSocialSubscriptions(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;
};

} // namespace wiki
} // namespace maps
