#include "dashboard_meta.h"

#include <maps/wikimap/mapspro/services/editor/src/configs/categories_strings.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>

#include <yandex/maps/wiki/configs/editor/category_groups.h>
#include <yandex/maps/wiki/social/common.h>

namespace maps {
namespace wiki {

namespace {
const std::string TASK_METHOD_NAME = "GetSocialDashboardMeta";
} // namespace


SocialModerationDashboardMeta::SocialModerationDashboardMeta(const Request& request)
    : controller::BaseController<SocialModerationDashboardMeta>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{}


std::string SocialModerationDashboardMeta::printRequest() const
{
    std::ostringstream os;
    os << " uid: " << request_.uid;
    return os.str();
}


void SocialModerationDashboardMeta::control()
{
    for (const auto& group : cfg()->editor()->categoryGroups().allGroups()) {
        if (group.first != CATEGORY_GROUP_SERVICE) {
            result_->categoryGroups.insert(group.first);
        }
    }
    for (const auto eventType : enum_io::enumerateValues<social::EventType>()) {
        // Closed-feedback was removed from dashboard frontend.
        // Can not remove ClosedFeedback from eventType enum yet.
        if (eventType != social::EventType::ClosedFeedback) {
            result_->eventTypes.emplace(toString(eventType));
        }
    }
}


const std::string& SocialModerationDashboardMeta::taskName()
{
    return TASK_METHOD_NAME;
}


} // namespace wiki
} // namespace maps
