#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps {
namespace wiki {

class GetSocialModerationStat;
template<>
struct controller::ResultType<GetSocialModerationStat>
{
    TUid uid;
    bool hasTasks;
};

class GetSocialModerationStat : public controller::BaseController<GetSocialModerationStat>
{
public:
    struct Request
    {
        const TUid uid;
        const Token token;
    };

    explicit GetSocialModerationStat(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    bool hasTasks() const;

    const Request request_;
};

} // namespace wiki
} // namespace maps
