#include "get_task.h"
#include "helpers.h"
#include <maps/wikimap/mapspro/services/editor/src/branch_helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/exception.h>
#include <maps/wikimap/mapspro/services/editor/src/acl_utils.h>
#include <maps/wikimap/mapspro/services/editor/src/social_utils.h>

#include <yandex/maps/wiki/social/gateway.h>

namespace maps {
namespace wiki {

GetSocialModerationTask::Request::Request(
        TUid uid,
        social::TId taskId,
        Token token)
    : user(uid)
    , taskId(taskId)
    , token(std::move(token))
{
    CHECK_REQUEST_PARAM(uid);
    CHECK_REQUEST_PARAM(taskId);
}

std::string
GetSocialModerationTask::Request::dump() const
{
    std::stringstream ss;
    ss << " uid: " << user
       << " task-id: " << taskId
       << " token: " << token;
    return ss.str();
}


GetSocialModerationTask::GetSocialModerationTask(const Request& request)
    : controller::BaseController<GetSocialModerationTask>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{}

std::string
GetSocialModerationTask::printRequest() const
{
    return request_.dump();
}

void
GetSocialModerationTask::control()
{
    auto branchCtx = CheckedTrunkBranchContextFacade()
        .acquireReadCoreSocial(request_.token);
    auto permissionsChecker = CheckPermissions(
        request_.user, branchCtx.txnCore());

    checkUserActiveStatus(branchCtx, request_.user);

    social::Gateway socialGw(branchCtx.txnSocial());
    auto tasks = socialGw.loadTasksByTaskIds({request_.taskId});
    WIKI_REQUIRE(
        tasks.size() == 1, ERR_NOT_FOUND,
        "Can not load moderation task: " << request_.taskId);
    result_->task = make_unique<social::Task>(std::move(tasks.front()));
    result_->requesterUid = request_.user;
    result_->alerts = loadPermittedAlerts(
        request_.taskId, socialGw, permissionsChecker);
}

} // namespace wiki
} // namespace maps
