#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <yandex/maps/wiki/social/task.h>
#include <yandex/maps/wiki/social/event_alert.h>

namespace maps {
namespace wiki {

class GetSocialModerationTask;
template<>
struct controller::ResultType<GetSocialModerationTask>
{
    std::unique_ptr<social::Task> task;
    social::EventAlerts alerts;
    TUid requesterUid;
};

class GetSocialModerationTask : public controller::BaseController<GetSocialModerationTask>
{
public:
    struct Request
    {
        Request(TUid uid, social::TId taskId, Token token);

        std::string dump() const;

        const TUid user;
        const social::TId taskId;
        const Token token;
    };

    explicit GetSocialModerationTask(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;
};

} // namespace wiki
} // namespace maps
