#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <yandex/maps/wiki/social/task.h>
#include <yandex/maps/wiki/social/event_alert.h>

namespace maps {
namespace wiki {

class GetSocialModerationTaskByCommit;
template<>
struct controller::ResultType<GetSocialModerationTaskByCommit>
{
    std::unique_ptr<social::Task> task;
    social::EventAlerts alerts;
};

class GetSocialModerationTaskByCommit : public controller::BaseController<GetSocialModerationTaskByCommit>
{
public:
    struct Request
    {
        Request(TUid uid, TCommitId commitId, Token token);

        std::string dump() const;

        const TUid user;
        const TCommitId commitId;
        const Token token;
    };

    explicit GetSocialModerationTaskByCommit(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;
};

} // namespace wiki
} // namespace maps
