#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <yandex/maps/wiki/social/date_time_condition.h>
#include <yandex/maps/wiki/social/task.h>
#include <yandex/maps/wiki/social/event_alert.h>
#include <yandex/maps/wiki/social/feed.h>

namespace maps {
namespace wiki {

class GetSocialModerationTasks;
template<>
struct controller::ResultType<GetSocialModerationTasks>
{
    social::Tasks tasks;
    social::HasMore hasMore = social::HasMore::No;
    std::map<social::TId, social::EventAlerts> alertsByTaskId;
    TId uid;
};

class GetSocialModerationTasks : public controller::BaseController<GetSocialModerationTasks>
{
public:
    struct Request
    {
        Request(social::TUid uid,
                Token token,
                social::TId before,
                social::TId after,
                size_t perPage,
                const std::optional<std::string>& categoryGroup,
                const std::optional<social::TUid>& resolvedBy,
                const std::optional<social::DateTimeCondition>& resolvedAt,
                const std::optional<social::ResolveResolution>& resolveResolution,
                const std::optional<social::TUid>& closedBy,
                const std::optional<social::DateTimeCondition>& closedAt,
                const std::optional<social::CloseResolution>& closeResolution);

        std::string dump() const;

        const social::TUid uid;
        const Token token;
        const social::TId before;
        const social::TId after;
        const size_t perPage;
        const std::optional<std::string> categoryGroup;
        const std::optional<social::TUid> resolvedBy;
        const std::optional<social::DateTimeCondition> resolvedAt;
        const std::optional<social::ResolveResolution> resolveResolution;
        const std::optional<social::TUid> closedBy;
        const std::optional<social::DateTimeCondition> closedAt;
        const std::optional<social::CloseResolution> closeResolution;
    };

    explicit GetSocialModerationTasks(const Request& request);

    virtual std::string printRequest() const;

    static const std::string& taskName();

protected:
    virtual void control();

private:
    const Request request_;
};

} // namespace wiki
} // namespace maps
