#pragma once

#include <maps/wikimap/mapspro/services/editor/src/commit.h>
#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/moderation.h>

#include <maps/wikimap/mapspro/libs/acl/include/user.h>
#include <yandex/maps/wiki/social/gateway.h>
#include <yandex/maps/wiki/social/task.h>

#include <maps/libs/json/include/value.h>

#include <map>
#include <vector>

namespace maps::wiki::moderation {

void checkJsonObject(const json::Value& jsonObject);

void checkAclTaskInfo(pqxx::transaction_base& work, TUid uid);

void checkTasksType(const social::Tasks& tasks, social::EventType desiredType);

json::Value requestJsonBody(
    const std::string& json, const std::string& taskName);

void checkRequestTaskIds(const social::TaskIds& taskIds);
social::TaskIds requestTaskIds(const json::Value& jsonObject);

boost::optional<RevertReason> requestRevertReason(
    const json::Value& jsonObject);

social::Tasks loadTasks(
    const social::Gateway& socialGateway,
    const social::TaskIds& taskIds,
    TUid uid,
    ResolveLockedByOther resolveLockedByOther = ResolveLockedByOther::No
);

void checkTasks(const social::Tasks& tasks);

bool hasComments(const social::Tasks& tasks);

bool hasFeedbackTasks(const social::Tasks& tasks);

TCommitIds commitIdsFromEditTasks(const social::Tasks& tasks);

struct RegionPolicy
{
    TOid aoiId;
    social::ModerationMode mode;
    StringSet categoryGroupIds;
    bool areCommonTasksPermitted;
};
using RegionPolicies = std::vector<RegionPolicy>;

TOIds collectAoiIds(const RegionPolicies& regionPolicies);

RegionPolicies createRegionPolicies(
    const acl::User& user,
    TOid aoiId = 0,
    const boost::optional<social::ModerationMode>& mode = boost::none);

bool areCommonTasksPermitted(const RegionPolicies& policies);

TCommitIds
getAutoApproveCommitIds(
    const BranchContext& branchCtx,
    const social::Gateway& socialGateway,
    const social::Tasks& tasks,
    const acl::User& user,
    const TOIds& aoiIds);

social::TaskIds
closeOrResolveRevertedTasks(
    BranchContext& branchCtx,
    const social::Gateway& socialGateway,
    const acl::User& user,
    const TCommitIds& revertedCommitIds,
    const TOIds& aoiIds,
    const TCommitIds& commitIds,
    bool isUserCartographer);

template<typename TSet>
TSet operator-(const TSet &lhs, const TSet &rhs) {
    TSet result;
    std::set_difference(
        lhs.cbegin(), lhs.cend(),
        rhs.cbegin(), rhs.cend(),
        std::inserter(result, result.begin())
    );
    return result;
}

} // namespace maps::wiki::moderation
