#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <yandex/maps/wiki/social/moderation.h>
#include <list>
#include <map>

namespace maps {
namespace wiki {

typedef std::map<std::string, social::TaskCounts> TaskCountersByCategoryGroup;

struct ModerationRegion
{
    TOid id;
    std::string categoryId;
    std::string title;
    Geom geometry;
    geos::geom::Envelope envelope;
    social::ModerationMode mode;
    social::TaskCounts taskCounters;
    TaskCountersByCategoryGroup taskCountersByCategoryGroup;
    size_t oldTaskAgeInHours;
};

class SocialModerationRegions;
template<>
struct controller::ResultType<SocialModerationRegions>
{
    std::list<ModerationRegion> regions;
};

class SocialModerationRegions : public controller::BaseController<SocialModerationRegions>
{
public:
    struct Request
    {
        const TUid uid;
        const Token token;
        boost::optional<social::ModerationMode> mode;
        boost::optional<maps::wiki::social::EventType> eventType;
        boost::optional<TUid> createdBy;
        boost::optional<TOid> primaryObjectId;
        const TOid aoiID;
        bool countByCategoryGroup;

        std::string dump() const;
    };

    explicit SocialModerationRegions(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    void loadRegions();

    const Request request_;
};

} // namespace wiki
} // namespace maps
