#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/services/editor/src/check_permissions.h>
#include <yandex/maps/wiki/social/task.h>
#include <yandex/maps/wiki/social/event_alert.h>
#include <yandex/maps/wiki/social/gateway.h>
#include <yandex/maps/wiki/social/moderation.h>
#include <yandex/maps/wiki/social/moderation_console.h>

#include <map>

namespace maps {
namespace wiki {

class ObserverCollection;
class SocialModerationTasksAcquire;
template<>
struct controller::ResultType<SocialModerationTasksAcquire>
{
    social::Tasks tasks;
    std::map<social::TId, social::EventAlerts> alertsByTaskId;
    Token token;
};

class SocialModerationTasksAcquire : public controller::BaseController<SocialModerationTasksAcquire>
{
public:
    struct Request
    {
        enum class SuspiciousOnly { No, Yes };
        enum class NovicesOnly { No, Yes };

        Request(
            TUid uid,
            TOid aoiId,
            social::ModerationMode mode,
            const boost::optional<std::string>& categoryGroup,
            const boost::optional<maps::wiki::social::EventType>& eventType,
            const boost::optional<TUid>& createdBy,
            const boost::optional<TUid>& resolvedBy,
            const boost::optional<TOid>& primaryObjectId,
            size_t limit,
            social::TasksOrder tasksOrder,
            SuspiciousOnly suspiciousOnly,
            NovicesOnly novicesOnly);

        Request(
            TUid uid,
            TOid aoiId,
            social::ModerationMode mode,
            size_t limit,
            social::TasksOrder tasksOrder);

        std::string dump() const;
        TUid userId() const { return user; }

        const TUid user;
        const TOid aoiId;
        const social::ModerationMode mode;
        boost::optional<std::string> categoryGroup;
        boost::optional<maps::wiki::social::EventType> eventType;
        boost::optional<TUid> createdBy;
        boost::optional<TUid> resolvedBy;
        boost::optional<TOid> primaryObjectId;
        const size_t limit;
        social::TasksOrder tasksOrder;
        SuspiciousOnly suspiciousOnly = SuspiciousOnly::No;
        NovicesOnly novicesOnly = NovicesOnly::No;
    };

    SocialModerationTasksAcquire(
        const ObserverCollection&,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;
};

} // namespace wiki
} // namespace maps
