#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "tasks_acquire.h"

namespace maps::wiki {

class ObserverCollection;

class SocialModerationTasksAcquireBlocking;
template<>
struct controller::ResultType<SocialModerationTasksAcquireBlocking>: controller::ResultType<SocialModerationTasksAcquire>
{};

class SocialModerationTasksAcquireBlocking: public controller::BaseController<SocialModerationTasksAcquireBlocking>
{
public:
    struct Request
    {
        Request(
            TUid uid,
            TCommitId commitId
        );

        std::string dump() const;
        TUid userId() const { return user; }

        const TUid user;
        const TCommitId commitId;
    };

    SocialModerationTasksAcquireBlocking(
        const ObserverCollection&,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    std::string printRequest() const override;

protected:
    void control() override;

private:
    const Request request_;
};

} // namespace maps::wiki
